%%[[if edit]]%%
<style>
code,kbd,pre,samp{font-family:Menlo,Monaco,Consolas,"Courier New",monospace}code{padding:.2rem .4rem;font-size:90%;color:#bd4147;background-color:#f7f7f9;border-radius:4px}kbd{padding:.2rem .4rem;font-size:90%;color:#fff;background-color:#333;border-radius:4px}kbd kbd{padding:0;font-size:100%;font-weight:700}pre{display:block;margin-top:0;margin-bottom:1rem;font-size:90%;line-height:1.5;color:#373a3c}pre code{padding:0;font-size:inherit;color:inherit;background-color:transparent;border-radius:0} .airtable-publisher-config-stack-title {font-weight: bold;} .airtable-publisher-config-stack-title td {	font-weight: bold;} .airtable-publisher-config-table td {font-size: 12px;	padding-right: 10px;	padding-top: 5px;} .airtable-publisher-config-table kbd {font-size: 12px;letter-spacing: 1px;}
</style>

<div>
	<span style="float: left;">
		<img src="%assetPath%/icon_small@2x.png" style="height:16px; width: auto;">
	</span>
	<span style="float: left; margin-left: 10px;">
			<span cstyle="margin-bottom: 0;">
				<span class="airtable-publisher-config-stack-title">Airtable Publisher Configuration</span>
				%[if %id=showConfig%]%
				<table class="airtable-publisher-config-table">
					<tbody>
						<tr>
							<td>API Key:</td>
							<td><kbd>%id=apiKey%</kbd></td>
						</tr>
						<tr>
							<td>Time Zone:</td>
							<td><kbd>%id=timeZone%</kbd></td>
						</tr>
						<tr>
							<td>User Locale:</td>
							<td><kbd>%id=userLocale%</kbd></td>
						</tr>
						<tr>
							<td>Query Param:</td>
							<td><kbd>%id=queryParam%</kbd></td>
						</tr>						
					</tbody>
				</table>
				%[endif]%
			</span>
		<div style="height: 0; clear: both;"></div>
</div>
%%[[endif]]%%

%%[[if !edit]]%%
<?php

ob_start();
$apiKey = "%id=apiKey%";
$timeZone = "%id=timeZone%";
$userLocale = "%id=userLocale%";
$queryParam = "%id=queryParam%";
//$cellFormat = "%id=cellFormat%";
$cellFormat = "string";
$tokenPrefix = "{{";
$tokenSuffix = "}}";


function callAirtable( 
			$baseID, $table, $recordID, 
			$fields, $filterColumn, $storeSession, 
			$searchFields, $filterByFormula, 
			$maxRecords, $pageSize, 
			$urlExtraParams, 
			$sortField, $view, $offset, 
			$introTemplate, $recordTemplate, $outroTemplate, $errorTemplate, 
			$debug, $showFields
	) {
		
	$url = 'https://api.airtable.com/v0/';
	
	global $apiKey, $cellFormat, $timeZone, $userLocale, $queryParam, $tokenPrefix, $tokenSuffix;
	
	if ( $baseID == '' ) {
		die( 'Please specify a Base ID.' );
	}
	$url .= $baseID . '/';

	if ( $table == '' ) {
		die( 'Please specify a Table.' );
	}
	$url .= rawurlencode( $table );
	
	// Retrieve a single record?
	if ( $recordID != '' || isset($_GET[$queryParam]) ) {
		
		if (!isset($_GET[$queryParam])) {
			$url .= '/' . $recordID . '/';
		} else {
			$url .= '/' . $_GET[$queryParam] . '/';
		}
		
		$url .= '?';
		
	} else {
		// otherwise get a result set:
		
		// Begin parameters.
		$url .= '?';
				
		// If specific fields are to be retrieved...
		if ( $fields != '' ) {
			$fields = str_replace( ', ', ',', $fields );
			$fields = explode( ',', $fields );
			foreach ( $fields as $field ) {
				$url .= '&fields%5B%5D=' . urlencode( $field );
			}
		}
		
		// Is a new search?
		if ( isset($_REQUEST['search']) ) {
			$searchTerm = $_REQUEST["search"];
			
			// are search fields overwritten by search form?
			if ( isset($_REQUEST["search_fields"]) && $_REQUEST["search_fields"] != '') $searchFields = $_REQUEST["search_fields"];
			
			unset($_SESSION['filter']);
			unset($_SESSION['preset']);
			
			if ( $searchFields != '' ) {
				$searchFields = str_replace( ', ', ',', $searchFields);
				$searchFields = explode( ',', $searchFields );
				$idx = 0;
				$url .= '&filterByFormula=OR(';
				foreach ( $searchFields as $searchField ) {
					$url .=  "SEARCH(LOWER('".urlencode( $searchTerm )."'),LOWER(".urlencode( $searchField )."))";
					$idx++;
					if ( $idx < count($searchFields)) {
						$url .= ',';
					}
				}
				$url .= ')' ; 
			}
			
		// Filter set?
		} else if ( isset($_GET[$filterColumn]) && $_GET[$filterColumn] == '_all') {
			unset($_SESSION['filter']);
		
		} else {
			// Shop list with previous selected category
			if ( $storeSession && !isset($_GET[$filterColumn]) ) {
				if ( $_SESSION['filter'] ) {
					unset($_SESSION['preset']);
					$url .= '&filterByFormula=' . $_SESSION['filter'];
				} 
			} 
		
			if ( $storeSession && isset($_GET[$filterColumn]) ) {
				$_SESSION['filter'] = urlencode( $filterColumn ."=".$_GET[$filterColumn] );
				unset($_SESSION['preset']);
				$url .= '&filterByFormula=' . $_SESSION['filter'];
			} 
		
			// Filter by category, but do not store filter in session 
			if ( !$storeSession && $filterColumn != ''and isset($_GET[$filterColumn]) ) {
				unset($_SESSION['preset']);
				$url .= '&filterByFormula=' . urlencode( $filterColumn ."=". $_GET[$filterColumn] );
			} 
		
			// No session, no category, filter by pre-defined criteria
			if ( !$_SESSION['filter'] && $filterByFormula != '' ) {
				$url .= '&filterByFormula=' . urlencode( $filterByFormula );
				$_SESSION['preset'] = $filterByFormula;
			}
		
		}
		
		// If a maxRecords was specified...
		if (  $maxRecords != '' ) {
			$url .= '&maxRecords=' . $maxRecords;
		}
		
		// If a pageSize was specified...
		if ( $pageSize != '' ) {
			$url .= '&pageSize=' . $pageSize;
		}
		
		// If a sort field was specified or send by url or set in session...
		if ( isset($_GET['sort']) ) {
			if ( $_GET['sort'] != '_none') {
				$_SESSION['sortField'] = $_GET['sort'];
				$_SESSION['sortOrder'] = $_GET['order'];
				$url .= '&sort[0][field]=' . urlencode( $_SESSION['sortField'] );
				$url .= '&sort[0][direction]=' . urlencode( $_SESSION['sortOrder'] );
			} else {
				$_SESSION['sortField'] = null;
				$_SESSION['sortOrder'] = null;
			}
		
		} else if ($_SESSION['sortField']) {
			$url .= '&sort[0][field]=' . urlencode( $_SESSION['sortField'] );
			$url .= '&sort[0][direction]=' . urlencode( $_SESSION['sortOrder'] );
		
		} else if ( !$_SESSION['sortField'] && 
								!isset($_GET['sort']) && 
								( $sortField != '' ) and 
								( $recordID == '' ) and
								(!isset($_GET[$queryParam])) ) {
			$url .= '&sort[0][field]=' . urlencode( $sortField );
			$url .= '&sort[0][direction]=' . urlencode( $sortOrder );
		}
		
		// If a view was specified...
		if ( $view != '' ) {
			$url .= '&view=' . urlencode( $view );
		}
		
	}
	
	// add global parameters:
		
	$url .= '&cellFormat=' . $cellFormat;
			
	if ( $timeZone != '' ) {
		$url .= '&timeZone=' . urlencode( $timeZone );
	}
	
	if ( $userLocale != '' ) {
		$url .= '&userLocale=' . urlencode( $userLocale );
	}
		
	if ( isset($_GET['offset']) ) {
		$url .= '&offset=' . urlencode( $_GET['offset'] );
	} else {
		// clear previous paging
		unset($pages);
		unset($_SESSION['pages']);
	}

	
	if ( $urlExtraParams != '' ) {
		$url .= '&' . $urlExtraParams;
	}
	
	// Create and configure a cURL instance.
	$ch = curl_init();
	curl_setopt( $ch, CURLOPT_URL, $url );
	curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'GET' );
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
	curl_setopt( $ch, CURLOPT_HTTPHEADER, [ 'Authorization: Bearer ' . $apiKey ] );
	$response = curl_exec( $ch );
	// echo '<pre>'; var_dump( $response ); echo '</pre>'; die;
	curl_close ($ch);
	
	$response = json_decode( $response, TRUE );
	// echo '<pre>'; var_dump( $response ); echo '</pre>'; die;
	
	// If the response included only a single record...
	if ( array_key_exists( 'fields', $response ) ) {
		$records = array();
		$records[0] = $response;
	} elseif ( array_key_exists( 'records', $response ) ) {
		$records = $response['records'];
	}
	
	// echo '<pre>'; var_dump( $records ); echo '</pre>'; die;
	
	// If an error occurred...
	if ( array_key_exists ( 'error', $response ) ) {
		
		echo $errorTemplate;
	
		if ( ( $debug ) && ( $_SERVER['REMOTE_ADDR'] == '127.0.0.1' ) ) {
			echo '<div style="background-color: red; color: white; margin-top: 24px; margin-bottom: 24px; padding: 9px;">' . PHP_EOL;
			echo '<span style="font-weight: bold;">Debug Information</span><br>' . PHP_EOL;
			echo '&bull; Error Type: ' . $response['error']['type'] . '<br>' . PHP_EOL;
			echo '&bull; Error Message: ' . $response['error']['message'] . '<br>' . PHP_EOL;
			echo '&bull; API URL: ' . $url . '<br>' . PHP_EOL;
			echo '</div>' . PHP_EOL;
		}
	
	// ..or if we want to see the fields returned by Airtable
	} elseif ( ( $showFields == 'true' ) && ( $_SERVER['REMOTE_ADDR'] == '127.0.0.1' ) ) {
	
		// Initialize the content that will actually be displayed.
		$content = '<h1>Fields</h1>' . PHP_EOL;
		// Get the first record's fields.
		$fields = $records[0]['fields'];
		// echo '<pre>'; var_dump( $fields ); echo '</pre>'; die;
		// Loop over the fields...
		foreach ( $fields as $key => $value ) {
			$content .= '<p>';
			$content .= '<span style="font-weight: bold;">' . $key . '</span><br>';
			$content .= '&bull; Token: ' . $tokenPrefix . $key . $tokenSuffix . '<br>';
			$content .= '&bull; Example: ' . $value;
			$content .= '</p>';
		}
		echo $content;
	
	} else {
		
		// no records founds?
		if ( sizeof($records) == 0 ) {
			$errorTemplate = str_replace( $tokenPrefix . 'searchTerm' . $tokenSuffix, $_REQUEST['search'], $errorTemplate );
			echo $errorTemplate;
	
		} else {
			
			// Otherwise iterate through all records and fill 
			// the record template.
			$content = '';
			
			// If a single record was returned...
			if ( array_key_exists( 'id', $response ) ) {
				$response['records'][0] = $response;
			}
			
			$recordNumber = 0;
			
			foreach ( $records as $record ) {
				$recordNumber = $recordNumber + 1;
				
				$recordContent = $recordTemplate;
				$recordContent = str_replace( $tokenPrefix . 'recordNumber' . $tokenSuffix, $recordNumber, $recordContent );
				$recordContent = str_replace( $tokenPrefix . 'recordID' . $tokenSuffix, $record['id'], $recordContent );
				$recordContent = str_replace( $tokenPrefix . 'createdTime' . $tokenSuffix, $record['createdTime'], $recordContent );
				
				$fields = $record['fields'];
				foreach ( $fields as $key => $value ) {
					// handle multiple attachments, 
					// retrieve the attachment URL from verbose string:
					if ( strpos($value,'.attachments') >0 ) {
						$recordContent = str_replace( $tokenPrefix.$key.'_raw'.$tokenSuffix, urlencode($value), $recordContent); // for further reference, store copy of all original values
						$value = explode(' (',$value)[1];
						$value = substr($value, 0, strpos($value,")") );
					} 
					$recordContent = str_replace( $tokenPrefix . $key . $tokenSuffix, $value, $recordContent);
				}
				$content .= $recordContent;
			}
			
			// Build the full content to be displayed.
			$content = $introTemplate . PHP_EOL . $content . PHP_EOL . $outroTemplate;
			
			// Replace any additional tokens that are supported.
			$content = str_replace( $tokenPrefix . 'recordCount' . $tokenSuffix, count( $response['records'] ), $content );
			$content = str_replace( $tokenPrefix . 'offset' . $tokenSuffix, $response['offset'], $content );
			$content = str_replace( $tokenPrefix . 'searchTerm' . $tokenSuffix, $_REQUEST['search'], $content );

			if ( response['offset'] ) {
				$iterator = explode($response['offset'],'/')[0];
				$_SESSION['currentPage']  = $iterator."/".$record['id'];
				$_SESSION['nextPage']  = $response['offset'];
			}
			
			// $content = str_replace( $tokenPrefix . 'previousPage' . $tokenSuffix, urlencode($_SESSION['lastPage']), $content );
			$content = str_replace( $tokenPrefix . 'nextPage' . $tokenSuffix, urlencode($response['offset']), $content );
				
			// Comment out any empty tokens.
			$content = str_replace( $tokenPrefix, '<!-- ', $content );
			$content = str_replace( $tokenSuffix, ' -->', $content );
			
			// Display the content with the substituted tokens.
			echo  $content;	
		}
				
	}	
	
	if ( $debug ) {
		echo '<pre><br><br>Debug:<br>';
		echo '<br>Base Config:<br>';
		echo 'API URL:       '.$url."\n";
		echo 'API Key:       '.$apiKey."\n";
		echo 'Time Zone:     '.$timeZone."\n";
		echo 'QueryParam:    '.$queryParam."\n";
		echo 'Cell Format:   '.$cellFormat."\n";
		echo 'Offset:        '.$response['offset']."\n";
		echo 'Search Fields: '.$searchFields."\n";
		echo 'Search Term:   '.$_REQUEST['search']."\n";
		
		echo '<br><br>Session';
		print_r($_SESSION);
		
		echo '</pre>';
	} 

}


?>
%%[[endif]]%%